/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.ShaderAttributeObjectRetained;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point2i;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Point4i;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple2i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Tuple4f;
import javax.vecmath.Tuple4i;

class ShaderAttributeArrayRetained
extends ShaderAttributeObjectRetained {
    ShaderAttributeArrayRetained() {
    }

    void initValue(int n2, Object object) {
        ((ArrayWrapper)this.attrWrapper).set(n2, object);
    }

    void setValue(int n2, Object object) {
        this.initValue(n2, object);
        this.setValue(this.attrWrapper.getRef());
    }

    int length() {
        return ((ArrayWrapper)this.attrWrapper).length();
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            ShaderAttributeArrayRetained shaderAttributeArrayRetained = new ShaderAttributeArrayRetained();
            shaderAttributeArrayRetained.createObjectData(this.getValue());
            this.mirror = shaderAttributeArrayRetained;
            this.mirror.source = this.source;
        }
        this.initMirrorObject();
    }

    int computeClassType(Object object) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new ClassCastException(clazz + " -- must be array class");
        }
        for (int i2 = 0; i2 < classTable.length; ++i2) {
            if (!classTableArr[i2].isInstance(object)) continue;
            return i2;
        }
        throw new ClassCastException(clazz + " -- unrecognized class");
    }

    Class getBaseClass(int n2) {
        return classTableArr[n2];
    }

    ShaderAttributeObjectRetained.AttrWrapper createAttrWrapper(Object object, int n2) {
        ArrayWrapper arrayWrapper = null;
        switch (n2) {
            case 0: {
                arrayWrapper = new IntegerArrayWrapper();
                break;
            }
            case 1: {
                arrayWrapper = new FloatArrayWrapper();
                break;
            }
            case 2: {
                arrayWrapper = new Tuple2iArrayWrapper();
                break;
            }
            case 3: {
                arrayWrapper = new Tuple2fArrayWrapper();
                break;
            }
            case 4: {
                arrayWrapper = new Tuple3iArrayWrapper();
                break;
            }
            case 5: {
                arrayWrapper = new Tuple3fArrayWrapper();
                break;
            }
            case 6: {
                arrayWrapper = new Tuple4iArrayWrapper();
                break;
            }
            case 7: {
                arrayWrapper = new Tuple4fArrayWrapper();
                break;
            }
            case 8: {
                arrayWrapper = new Matrix3fArrayWrapper();
                break;
            }
            case 9: {
                arrayWrapper = new Matrix4fArrayWrapper();
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        arrayWrapper.set(object);
        return arrayWrapper;
    }

    static abstract class ArrayWrapper
    extends ShaderAttributeObjectRetained.AttrWrapper {
        int length = 0;

        ArrayWrapper() {
        }

        int length() {
            return this.length;
        }

        abstract void set(int var1, Object var2);
    }

    static class FloatArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        FloatArrayWrapper() {
        }

        void set(Object object) {
            Float[] floatArray = (Float[])object;
            if (this.length != floatArray.length) {
                this.length = floatArray.length;
                this.value = new float[this.length];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.value[i2] = floatArray[i2].floatValue();
            }
        }

        void set(int n2, Object object) {
            this.value[n2] = ((Float)object).floatValue();
        }

        Object get() {
            Float[] floatArray = new Float[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                floatArray[i2] = new Float(this.value[i2]);
            }
            return floatArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class IntegerArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        IntegerArrayWrapper() {
        }

        void set(Object object) {
            Integer[] integerArray = (Integer[])object;
            if (this.length != integerArray.length) {
                this.length = integerArray.length;
                this.value = new int[this.length];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.value[i2] = integerArray[i2];
            }
        }

        void set(int n2, Object object) {
            this.value[n2] = (Integer)object;
        }

        Object get() {
            Integer[] integerArray = new Integer[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                integerArray[i2] = new Integer(this.value[i2]);
            }
            return integerArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Matrix3fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Matrix3fArrayWrapper() {
        }

        void set(Object object) {
            Matrix3f[] matrix3fArray = (Matrix3f[])object;
            if (this.length != matrix3fArray.length) {
                this.length = matrix3fArray.length;
                this.value = new float[this.length * 9];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 9;
                this.value[n2 + 0] = matrix3fArray[i2].m00;
                this.value[n2 + 1] = matrix3fArray[i2].m01;
                this.value[n2 + 2] = matrix3fArray[i2].m02;
                this.value[n2 + 3] = matrix3fArray[i2].m10;
                this.value[n2 + 4] = matrix3fArray[i2].m11;
                this.value[n2 + 5] = matrix3fArray[i2].m12;
                this.value[n2 + 6] = matrix3fArray[i2].m20;
                this.value[n2 + 7] = matrix3fArray[i2].m21;
                this.value[n2 + 8] = matrix3fArray[i2].m22;
            }
        }

        void set(int n2, Object object) {
            int n3 = n2 * 9;
            Matrix3f matrix3f = (Matrix3f)object;
            this.value[n3 + 0] = matrix3f.m00;
            this.value[n3 + 1] = matrix3f.m01;
            this.value[n3 + 2] = matrix3f.m02;
            this.value[n3 + 3] = matrix3f.m10;
            this.value[n3 + 4] = matrix3f.m11;
            this.value[n3 + 5] = matrix3f.m12;
            this.value[n3 + 6] = matrix3f.m20;
            this.value[n3 + 7] = matrix3f.m21;
            this.value[n3 + 8] = matrix3f.m22;
        }

        Object get() {
            Matrix3f[] matrix3fArray = new Matrix3f[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 9;
                matrix3fArray[i2] = new Matrix3f();
                matrix3fArray[i2].m00 = this.value[n2 + 0];
                matrix3fArray[i2].m01 = this.value[n2 + 1];
                matrix3fArray[i2].m02 = this.value[n2 + 2];
                matrix3fArray[i2].m10 = this.value[n2 + 3];
                matrix3fArray[i2].m11 = this.value[n2 + 4];
                matrix3fArray[i2].m12 = this.value[n2 + 5];
                matrix3fArray[i2].m20 = this.value[n2 + 6];
                matrix3fArray[i2].m21 = this.value[n2 + 7];
                matrix3fArray[i2].m22 = this.value[n2 + 8];
            }
            return matrix3fArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Matrix4fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Matrix4fArrayWrapper() {
        }

        void set(Object object) {
            Matrix4f[] matrix4fArray = (Matrix4f[])object;
            if (this.length != matrix4fArray.length) {
                this.length = matrix4fArray.length;
                this.value = new float[this.length * 16];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 16;
                this.value[n2 + 0] = matrix4fArray[i2].m00;
                this.value[n2 + 1] = matrix4fArray[i2].m01;
                this.value[n2 + 2] = matrix4fArray[i2].m02;
                this.value[n2 + 3] = matrix4fArray[i2].m03;
                this.value[n2 + 4] = matrix4fArray[i2].m10;
                this.value[n2 + 5] = matrix4fArray[i2].m11;
                this.value[n2 + 6] = matrix4fArray[i2].m12;
                this.value[n2 + 7] = matrix4fArray[i2].m13;
                this.value[n2 + 8] = matrix4fArray[i2].m20;
                this.value[n2 + 9] = matrix4fArray[i2].m21;
                this.value[n2 + 10] = matrix4fArray[i2].m22;
                this.value[n2 + 11] = matrix4fArray[i2].m23;
                this.value[n2 + 12] = matrix4fArray[i2].m30;
                this.value[n2 + 13] = matrix4fArray[i2].m31;
                this.value[n2 + 14] = matrix4fArray[i2].m32;
                this.value[n2 + 15] = matrix4fArray[i2].m33;
            }
        }

        void set(int n2, Object object) {
            int n3 = n2 * 16;
            Matrix4f matrix4f = (Matrix4f)object;
            this.value[n3 + 0] = matrix4f.m00;
            this.value[n3 + 1] = matrix4f.m01;
            this.value[n3 + 2] = matrix4f.m02;
            this.value[n3 + 3] = matrix4f.m03;
            this.value[n3 + 4] = matrix4f.m10;
            this.value[n3 + 5] = matrix4f.m11;
            this.value[n3 + 6] = matrix4f.m12;
            this.value[n3 + 7] = matrix4f.m13;
            this.value[n3 + 8] = matrix4f.m20;
            this.value[n3 + 9] = matrix4f.m21;
            this.value[n3 + 10] = matrix4f.m22;
            this.value[n3 + 11] = matrix4f.m23;
            this.value[n3 + 12] = matrix4f.m30;
            this.value[n3 + 13] = matrix4f.m31;
            this.value[n3 + 14] = matrix4f.m32;
            this.value[n3 + 15] = matrix4f.m33;
        }

        Object get() {
            Matrix4f[] matrix4fArray = new Matrix4f[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 16;
                matrix4fArray[i2] = new Matrix4f();
                matrix4fArray[i2].m00 = this.value[n2 + 0];
                matrix4fArray[i2].m01 = this.value[n2 + 1];
                matrix4fArray[i2].m02 = this.value[n2 + 2];
                matrix4fArray[i2].m03 = this.value[n2 + 3];
                matrix4fArray[i2].m10 = this.value[n2 + 4];
                matrix4fArray[i2].m11 = this.value[n2 + 5];
                matrix4fArray[i2].m12 = this.value[n2 + 6];
                matrix4fArray[i2].m13 = this.value[n2 + 7];
                matrix4fArray[i2].m20 = this.value[n2 + 8];
                matrix4fArray[i2].m21 = this.value[n2 + 9];
                matrix4fArray[i2].m22 = this.value[n2 + 10];
                matrix4fArray[i2].m23 = this.value[n2 + 11];
                matrix4fArray[i2].m30 = this.value[n2 + 12];
                matrix4fArray[i2].m31 = this.value[n2 + 13];
                matrix4fArray[i2].m32 = this.value[n2 + 14];
                matrix4fArray[i2].m33 = this.value[n2 + 15];
            }
            return matrix4fArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple2fArrayWrapper() {
        }

        void set(Object object) {
            Tuple2f[] tuple2fArray = (Tuple2f[])object;
            if (this.length != tuple2fArray.length) {
                this.length = tuple2fArray.length;
                this.value = new float[this.length * 2];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 2;
                this.value[n2 + 0] = tuple2fArray[i2].x;
                this.value[n2 + 1] = tuple2fArray[i2].y;
            }
        }

        void set(int n2, Object object) {
            int n3 = n2 * 2;
            this.value[n3 + 0] = ((Tuple2f)object).x;
            this.value[n3 + 1] = ((Tuple2f)object).y;
        }

        Object get() {
            Tuple2f[] tuple2fArray = new Tuple2f[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 2;
                tuple2fArray[i2] = new Point2f();
                tuple2fArray[i2].x = this.value[n2 + 0];
                tuple2fArray[i2].y = this.value[n2 + 1];
            }
            return tuple2fArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple2iArrayWrapper() {
        }

        void set(Object object) {
            Tuple2i[] tuple2iArray = (Tuple2i[])object;
            if (this.length != tuple2iArray.length) {
                this.length = tuple2iArray.length;
                this.value = new int[this.length * 2];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 2;
                this.value[n2 + 0] = tuple2iArray[i2].x;
                this.value[n2 + 1] = tuple2iArray[i2].y;
            }
        }

        void set(int n2, Object object) {
            int n3 = n2 * 2;
            this.value[n3 + 0] = ((Tuple2i)object).x;
            this.value[n3 + 1] = ((Tuple2i)object).y;
        }

        Object get() {
            Tuple2i[] tuple2iArray = new Tuple2i[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 2;
                tuple2iArray[i2] = new Point2i();
                tuple2iArray[i2].x = this.value[n2 + 0];
                tuple2iArray[i2].y = this.value[n2 + 1];
            }
            return tuple2iArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple3fArrayWrapper() {
        }

        void set(Object object) {
            Tuple3f[] tuple3fArray = (Tuple3f[])object;
            if (this.length != tuple3fArray.length) {
                this.length = tuple3fArray.length;
                this.value = new float[this.length * 3];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 3;
                this.value[n2 + 0] = tuple3fArray[i2].x;
                this.value[n2 + 1] = tuple3fArray[i2].y;
                this.value[n2 + 2] = tuple3fArray[i2].z;
            }
        }

        void set(int n2, Object object) {
            int n3 = n2 * 3;
            this.value[n3 + 0] = ((Tuple3f)object).x;
            this.value[n3 + 1] = ((Tuple3f)object).y;
            this.value[n3 + 2] = ((Tuple3f)object).z;
        }

        Object get() {
            Tuple3f[] tuple3fArray = new Tuple3f[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 3;
                tuple3fArray[i2] = new Point3f();
                tuple3fArray[i2].x = this.value[n2 + 0];
                tuple3fArray[i2].y = this.value[n2 + 1];
                tuple3fArray[i2].z = this.value[n2 + 2];
            }
            return tuple3fArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple3iArrayWrapper() {
        }

        void set(Object object) {
            Tuple3i[] tuple3iArray = (Tuple3i[])object;
            if (this.length != tuple3iArray.length) {
                this.length = tuple3iArray.length;
                this.value = new int[this.length * 3];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 3;
                this.value[n2 + 0] = tuple3iArray[i2].x;
                this.value[n2 + 1] = tuple3iArray[i2].y;
                this.value[n2 + 2] = tuple3iArray[i2].z;
            }
        }

        void set(int n2, Object object) {
            int n3 = n2 * 3;
            this.value[n3 + 0] = ((Tuple3i)object).x;
            this.value[n3 + 1] = ((Tuple3i)object).y;
            this.value[n3 + 2] = ((Tuple3i)object).z;
        }

        Object get() {
            Tuple3i[] tuple3iArray = new Tuple3i[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 3;
                tuple3iArray[i2] = new Point3i();
                tuple3iArray[i2].x = this.value[n2 + 0];
                tuple3iArray[i2].y = this.value[n2 + 1];
                tuple3iArray[i2].z = this.value[n2 + 2];
            }
            return tuple3iArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple4fArrayWrapper() {
        }

        void set(Object object) {
            Tuple4f[] tuple4fArray = (Tuple4f[])object;
            if (this.length != tuple4fArray.length) {
                this.length = tuple4fArray.length;
                this.value = new float[this.length * 4];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 4;
                this.value[n2 + 0] = tuple4fArray[i2].x;
                this.value[n2 + 1] = tuple4fArray[i2].y;
                this.value[n2 + 2] = tuple4fArray[i2].z;
                this.value[n2 + 3] = tuple4fArray[i2].w;
            }
        }

        void set(int n2, Object object) {
            int n3 = n2 * 4;
            this.value[n3 + 0] = ((Tuple4f)object).x;
            this.value[n3 + 1] = ((Tuple4f)object).y;
            this.value[n3 + 2] = ((Tuple4f)object).z;
            this.value[n3 + 3] = ((Tuple4f)object).w;
        }

        Object get() {
            Tuple4f[] tuple4fArray = new Tuple4f[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 4;
                tuple4fArray[i2] = new Point4f();
                tuple4fArray[i2].x = this.value[n2 + 0];
                tuple4fArray[i2].y = this.value[n2 + 1];
                tuple4fArray[i2].z = this.value[n2 + 2];
                tuple4fArray[i2].w = this.value[n2 + 3];
            }
            return tuple4fArray;
        }

        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple4iArrayWrapper() {
        }

        void set(Object object) {
            Tuple4i[] tuple4iArray = (Tuple4i[])object;
            if (this.length != tuple4iArray.length) {
                this.length = tuple4iArray.length;
                this.value = new int[this.length * 4];
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 4;
                this.value[n2 + 0] = tuple4iArray[i2].x;
                this.value[n2 + 1] = tuple4iArray[i2].y;
                this.value[n2 + 2] = tuple4iArray[i2].z;
                this.value[n2 + 3] = tuple4iArray[i2].w;
            }
        }

        void set(int n2, Object object) {
            int n3 = n2 * 4;
            this.value[n3 + 0] = ((Tuple4i)object).x;
            this.value[n3 + 1] = ((Tuple4i)object).y;
            this.value[n3 + 2] = ((Tuple4i)object).z;
            this.value[n3 + 3] = ((Tuple4i)object).w;
        }

        Object get() {
            Tuple4i[] tuple4iArray = new Tuple4i[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n2 = i2 * 4;
                tuple4iArray[i2] = new Point4i();
                tuple4iArray[i2].x = this.value[n2 + 0];
                tuple4iArray[i2].y = this.value[n2 + 1];
                tuple4iArray[i2].z = this.value[n2 + 2];
                tuple4iArray[i2].w = this.value[n2 + 3];
            }
            return tuple4iArray;
        }

        Object getRef() {
            return this.value;
        }
    }
}

